// Main application entry point
import './css/styles.css';

// Application state
const state = {
  currentView: 'announcements',
  contests: [],
  photos: []
};

// Initialize the application
function init() {
  renderNavigation();
  loadInitialData();
  renderContent();
  applyTheme();
}

// Render navigation
function renderNavigation() {
  const navLinks = document.querySelectorAll('nav a');
  navLinks.forEach(link => {
    link.addEventListener('click', (e) => {
      e.preventDefault();
      state.currentView = link.getAttribute('href')?.substring(1) || 'announcements';
      renderContent();
    });
  });
}

// Load initial data
function loadInitialData() {
  // TODO: Implement data loading
}

// Render content based on current view
function renderContent() {
  const contentSection = document.getElementById('content');
  if (!contentSection) return;

  switch (state.currentView) {
    case 'announcements':
      contentSection.innerHTML = '<h2>Contest Announcements</h2><div class="announcements"></div>';
      break;
    case 'results':
      contentSection.innerHTML = '<h2>Contest Results</h2><div class="results"></div>';
      break;
    case 'gallery':
      contentSection.innerHTML = '<h2>Photo Gallery</h2><div class="gallery"></div>';
      break;
    case 'register':
      contentSection.innerHTML = '<h2>Register for Contest</h2><div class="register-form"></div>';
      break;
  }
}

// Apply theme colors
function applyTheme() {
  document.body.style.backgroundColor = 'mintcream';
  document.body.style.color = 'teal';
}

// Initialize the app when DOM is loaded
document.addEventListener('DOMContentLoaded', init);