class App {
    private posts: Array<{id: number, title: string, content: string, replies: Array<{content: string}>}> = [];
    private currentId = 1;

    init() {
        this.renderUI();
        this.setupEventListeners();
    }

    private renderUI() {
        const appElement = document.getElementById('app');
        if (appElement) {
            appElement.innerHTML = `
                <h1>Campus Discussion Forum</h1>
                <div class="forum-container">
                    <div class="post-form">
                        <h2>Create New Post</h2>
                        <input type="text" id="post-title" placeholder="Post title">
                        <textarea id="post-content" placeholder="Your post content"></textarea>
                        <button class="button" id="submit-post">Submit Post</button>
                    </div>
                    <div class="posts-list" id="posts-container"></div>
                </div>
            `;
        }
    }

    private setupEventListeners() {
        document.getElementById('submit-post')?.addEventListener('click', () => this.createPost());
    }

    private createPost() {
        const titleInput = document.getElementById('post-title') as HTMLInputElement;
        const contentInput = document.getElementById('post-content') as HTMLTextAreaElement;
        
        if (titleInput.value && contentInput.value) {
            const newPost = {
                id: this.currentId++,
                title: titleInput.value,
                content: contentInput.value,
                replies: []
            };
            this.posts.push(newPost);
            this.renderPosts();
            titleInput.value = '';
            contentInput.value = '';
        }
    }

    private renderPosts() {
        const postsContainer = document.getElementById('posts-container');
        if (postsContainer) {
            postsContainer.innerHTML = this.posts.map(post => `
                <div class="post" data-id="${post.id}">
                    <h3>${post.title}</h3>
                    <p>${post.content}</p>
                    <div class="replies">
                        ${post.replies.map(reply => `<p class="reply">${reply.content}</p>`).join('')}
                    </div>
                    <textarea class="reply-input" placeholder="Write a reply..."></textarea>
                    <button class="button reply-button">Reply</button>
                </div>
            `).join('');
        }
    }
}

export { App };