"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(require("react"));
const react_router_dom_1 = require("react-router-dom");
const ReportForm_1 = __importDefault(require("./ReportForm"));
const NavLink = ({ to, children }) => {
    const resolvedPath = (0, react_router_dom_1.useResolvedPath)(to);
    const isActive = (0, react_router_dom_1.useMatch)({ path: resolvedPath.pathname, end: true });
    return (react_1.default.createElement(react_router_dom_1.Link, { to: to, className: isActive ? 'active' : '' }, children));
};
const App = () => {
    return (react_1.default.createElement(react_router_dom_1.BrowserRouter, null,
        react_1.default.createElement("div", { className: "app" },
            react_1.default.createElement("nav", null,
                react_1.default.createElement(NavLink, { to: "/" }, "Home"),
                react_1.default.createElement(NavLink, { to: "/report" }, "Report"),
                react_1.default.createElement(NavLink, { to: "/forum" }, "Forum"),
                react_1.default.createElement(NavLink, { to: "/news" }, "News")),
            react_1.default.createElement(react_router_dom_1.Routes, null,
                react_1.default.createElement(react_router_dom_1.Route, { path: "/", element: react_1.default.createElement("div", null,
                        react_1.default.createElement("h2", null, "Welcome to Whistleblower Network"),
                        react_1.default.createElement("p", null, "A secure platform for anonymous truth sharing"),
                        react_1.default.createElement("section", { className: "features" },
                            react_1.default.createElement("div", { className: "card" },
                                react_1.default.createElement("h3", null, "Anonymous Reporting"),
                                react_1.default.createElement("p", null, "Submit sensitive information securely")),
                            react_1.default.createElement("div", { className: "card" },
                                react_1.default.createElement("h3", null, "Discussion Forum"),
                                react_1.default.createElement("p", null, "Join conversations about important issues")),
                            react_1.default.createElement("div", { className: "card" },
                                react_1.default.createElement("h3", null, "News & Analysis"),
                                react_1.default.createElement("p", null, "Stay informed with verified reports")))) }),
                react_1.default.createElement(react_router_dom_1.Route, { path: "/report", element: react_1.default.createElement(ReportForm_1.default, null) }),
                react_1.default.createElement(react_router_dom_1.Route, { path: "/forum", element: react_1.default.createElement("div", null, "Forum coming soon") }),
                react_1.default.createElement(react_router_dom_1.Route, { path: "/news", element: react_1.default.createElement("div", null, "News coming soon") })))));
};
exports.default = App;
