"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const path_1 = __importDefault(require("path"));
const webpack_1 = __importDefault(require("webpack"));
const webpack_dev_middleware_1 = __importDefault(require("webpack-dev-middleware"));
const webpack_hot_middleware_1 = __importDefault(require("webpack-hot-middleware"));
const webpack_config_1 = __importDefault(require("../webpack.config"));
const app = (0, express_1.default)();
const PORT = process.env.PORT || 3000;
const compiler = (0, webpack_1.default)(webpack_config_1.default[0]); // Client config
// Webpack middleware for development
if (process.env.NODE_ENV === 'development') {
    app.use((0, webpack_dev_middleware_1.default)(compiler, {
        publicPath: webpack_config_1.default[0].output.publicPath
    }));
    app.use((0, webpack_hot_middleware_1.default)(compiler));
}
// Static files
app.use(express_1.default.static(path_1.default.join(__dirname, '../public')));
// API routes will be added here
// Handle client-side routing
app.get('*', (req, res) => {
    res.sendFile(path_1.default.join(__dirname, '../public/index.html'));
});
// Error handling
app.use((err, req, res, next) => {
    console.error(err.stack);
    res.status(500).send('Something broke!');
});
app.listen(PORT, () => {
    console.log(`Server running on http://localhost:${PORT}`);
});
