import React from 'react';
import { BrowserRouter as Router, Routes, Route, Link, useMatch, useResolvedPath } from 'react-router-dom';
import ReportForm from './ReportForm';

interface NavLinkProps {
  to: string;
  children: React.ReactNode;
}

const NavLink = ({ to, children }: NavLinkProps) => {
  const resolvedPath = useResolvedPath(to);
  const isActive = useMatch({ path: resolvedPath.pathname, end: true });
  
  return (
    <Link to={to} className={isActive ? 'active' : ''}>
      {children}
    </Link>
  );
};

const App: React.FC = () => {
  return (
    <Router>
      <div className="app">
        <nav>
          <NavLink to="/">Home</NavLink>
          <NavLink to="/report">Report</NavLink>
          <NavLink to="/forum">Forum</NavLink>
          <NavLink to="/news">News</NavLink>
        </nav>

        <Routes>
          <Route path="/" element={
            <div>
              <h2>Welcome to Whistleblower Network</h2>
              <p>A secure platform for anonymous truth sharing</p>
              <section className="features">
                <div className="card">
                  <h3>Anonymous Reporting</h3>
                  <p>Submit sensitive information securely</p>
                </div>
                <div className="card">
                  <h3>Discussion Forum</h3>
                  <p>Join conversations about important issues</p>
                </div>
                <div className="card">
                  <h3>News & Analysis</h3>
                  <p>Stay informed with verified reports</p>
                </div>
              </section>
            </div>
          } />
          <Route path="/report" element={<ReportForm />} />
          <Route path="/forum" element={<div>Forum coming soon</div>} />
          <Route path="/news" element={<div>News coming soon</div>} />
        </Routes>
      </div>
    </Router>
  );
};

export default App;