import React, { useState } from 'react';

const ReportForm: React.FC = () => {
  const [title, setTitle] = useState('');
  const [description, setDescription] = useState('');
  const [evidence, setEvidence] = useState<File | null>(null);

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault();
    // Submit logic will be added later
    console.log({ title, description, evidence });
    alert('Report submitted anonymously. Thank you for your courage.');
    setTitle('');
    setDescription('');
    setEvidence(null);
  };

  return (
    <form className="report-form" onSubmit={handleSubmit}>
      <h3>Submit Anonymous Report</h3>
      <div className="form-group">
        <label>Title:</label>
        <input 
          type="text" 
          value={title}
          onChange={(e) => setTitle(e.target.value)}
          required
        />
      </div>
      <div className="form-group">
        <label>Description:</label>
        <textarea
          value={description}
          onChange={(e) => setDescription(e.target.value)}
          required
        />
      </div>
      <div className="form-group">
        <label>Evidence (optional):</label>
        <input 
          type="file" 
          onChange={(e) => setEvidence(e.target.files?.[0] || null)}
        />
      </div>
      <button type="submit">Submit Report</button>
    </form>
  );
};

export default ReportForm;