import express from 'express';
import path from 'path';
import webpack from 'webpack';
import webpackDevMiddleware from 'webpack-dev-middleware';
import webpackHotMiddleware from 'webpack-hot-middleware';
import config from '../webpack.config';

const app = express();
const PORT = process.env.PORT || 3000;
const compiler = webpack(config[0]); // Client config

// Webpack middleware for development
if (process.env.NODE_ENV === 'development') {
  app.use(webpackDevMiddleware(compiler, {
    publicPath: config[0].output.publicPath
  }));
  app.use(webpackHotMiddleware(compiler));
}

// Static files
app.use(express.static(path.join(__dirname, '../public')));

// API routes will be added here

// Handle client-side routing
app.get('*', (req, res) => {
  res.sendFile(path.join(__dirname, '../public/index.html'));
});

// Error handling
app.use((err: Error, req: express.Request, res: express.Response, next: express.NextFunction) => {
  console.error(err.stack);
  res.status(500).send('Something broke!');
});

app.listen(PORT, () => {
  console.log(`Server running on http://localhost:${PORT}`);
});