"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const webpack_node_externals_1 = __importDefault(require("webpack-node-externals"));
require("webpack-dev-server");
const clientConfig = {
    name: 'client',
    target: 'web',
    entry: './src/client.tsx',
    output: {
        path: path_1.default.resolve(__dirname, 'dist/public'),
        filename: 'bundle.js',
        publicPath: '/'
    },
    module: {
        rules: [
            {
                test: /\.(ts|tsx)$/,
                loader: 'ts-loader',
                exclude: /node_modules/
            }
        ]
    },
    resolve: {
        extensions: ['.ts', '.tsx', '.js']
    },
    devServer: {
        static: {
            directory: path_1.default.join(__dirname, 'public'),
        },
        hot: true,
    }
};
const serverConfig = {
    name: 'server',
    target: 'node',
    externals: [(0, webpack_node_externals_1.default)()],
    entry: './src/index.ts',
    output: {
        path: path_1.default.resolve(__dirname, 'dist'),
        filename: 'server.js'
    },
    module: {
        rules: [
            {
                test: /\.(ts|tsx)$/,
                loader: 'ts-loader',
                exclude: /node_modules/
            }
        ]
    },
    resolve: {
        extensions: ['.ts', '.tsx', '.js']
    }
};
exports.default = [clientConfig, serverConfig];
