interface Question {
  id: number;
  text: string;
  answers: Answer[];
}

interface Answer {
  id: number;
  text: string;
  rating: number;
}

const questions: Question[] = [];

function renderApp() {
  const app = document.getElementById('app')!;
  app.innerHTML = `
    <div class="container">
      <h1>Q&A Website</h1>
      ${renderQuestionForm()}
      ${renderQuestionsList()}
    </div>
  `;
}

function renderQuestionForm() {
  return `
    <div class="question-form">
      <h2>Ask a Question</h2>
      <textarea id="question-input" placeholder="Enter your question"></textarea>
      <button id="submit-question">Submit</button>
    </div>
  `;
}

function renderQuestionsList() {
  return `
    <div class="questions-list">
      <h2>Questions</h2>
      ${questions.map(renderQuestion).join('')}
    </div>
  `;
}

function renderQuestion(question: Question) {
  return `
    <div class="question">
      <h3>${question.text}</h3>
      ${renderAnswerForm(question.id)}
      ${question.answers.map(renderAnswer).join('')}
    </div>
  `;
}

function renderAnswerForm(questionId: number) {
  return `
    <div class="answer-form">
      <textarea id="answer-input-${questionId}" placeholder="Enter your answer"></textarea>
      <button onclick="submitAnswer(${questionId})">Submit Answer</button>
    </div>
  `;
}

function renderAnswer(answer: Answer) {
  return `
    <div class="answer">
      <p>${answer.text}</p>
      <div class="rating">
        <span>Rating: ${answer.rating}</span>
        <button onclick="rateAnswer(${answer.id}, 1)">👍</button>
        <button onclick="rateAnswer(${answer.id}, -1)">👎</button>
      </div>
    </div>
  `;
}

// Initialize the app
renderApp();