import { Routes, Route } from 'react-router-dom'
import Home from './pages/Home'
import Services from './pages/Services'
import Blog from './pages/Blog'
import Podcasts from './pages/Podcasts'
import Navbar from './components/Navbar'
import Footer from './components/Footer'
import './styles/main.css'

function App() {
  return (
    <div className="app">
      <Navbar />
      <main>
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/services" element={<Services />} />
          <Route path="/blog" element={<Blog />} />
          <Route path="/podcasts" element={<Podcasts />} />
        </Routes>
      </main>
      <Footer />
    </div>
  )
}

export default App