import '../styles/main.css'

const podcastEpisodes = [
  {
    id: 1,
    title: 'Leadership in Uncertain Times',
    description: 'How to guide your team through challenging periods',
    duration: '42 min',
    date: 'March 5, 2024'
  },
  {
    id: 2,
    title: 'The Future of Remote Work',
    description: 'Strategies for managing distributed teams effectively',
    duration: '38 min',
    date: 'February 20, 2024'
  },
  {
    id: 3,
    title: 'Innovation Culture',
    description: 'Building environments that foster creativity and growth',
    duration: '45 min',
    date: 'February 5, 2024'
  }
]

function Podcasts() {
  return (
    <div className="podcasts-page" style={{ maxWidth: '1200px', margin: '0 auto', padding: '2rem' }}>
      <h1>Business Leadership Podcast</h1>
      <p style={{ marginBottom: '2rem' }}>Listen to our latest episodes on leadership and business strategy</p>
      
      <div style={{ display: 'grid', gap: '1.5rem' }}>
        {podcastEpisodes.map(episode => (
          <div key={episode.id} style={{
            backgroundColor: 'white',
            padding: '1.5rem',
            borderRadius: '8px',
            boxShadow: '0 2px 4px rgba(0,0,0,0.1)',
            display: 'flex',
            alignItems: 'center'
          }}>
            <div style={{
              width: '60px',
              height: '60px',
              backgroundColor: 'var(--primary-color)',
              borderRadius: '50%',
              display: 'flex',
              alignItems: 'center',
              justifyContent: 'center',
              color: 'white',
              marginRight: '1.5rem',
              flexShrink: 0
            }}>
              ▶
            </div>
            <div>
              <h3 style={{ margin: '0 0 0.5rem 0', color: 'var(--primary-color)' }}>{episode.title}</h3>
              <p style={{ margin: '0 0 0.5rem 0' }}>{episode.description}</p>
              <div style={{ display: 'flex', gap: '1rem', color: '#888' }}>
                <span>{episode.duration}</span>
                <span>{episode.date}</span>
              </div>
            </div>
          </div>
        ))}
      </div>
    </div>
  )
}

export default Podcasts