import { useState } from 'react'
import '../styles/main.css'

const services = [
  {
    id: 1,
    name: 'Leadership Workshop',
    description: 'Full-day intensive workshop on modern leadership techniques',
    price: 299,
    duration: '8 hours'
  },
  {
    id: 2,
    name: 'Business Strategy Session',
    description: 'One-on-one consulting session to develop your business strategy',
    price: 199,
    duration: '2 hours'
  },
  {
    id: 3,
    name: 'Online Course Bundle',
    description: 'Access to all our premium online courses for one year',
    price: 499,
    duration: '1 year access'
  }
]

function Services() {
  const [cart, setCart] = useState<number[]>([])

  const addToCart = (id: number) => {
    setCart([...cart, id])
  }

  return (
    <div className="services-page" style={{ maxWidth: '1200px', margin: '0 auto', padding: '2rem' }}>
      <h1>Our Training Services</h1>
      <div style={{ display: 'grid', gridTemplateColumns: 'repeat(auto-fit, minmax(300px, 1fr))', gap: '2rem' }}>
        {services.map(service => (
          <div key={service.id} style={{
            backgroundColor: 'white',
            padding: '1.5rem',
            borderRadius: '8px',
            boxShadow: '0 2px 4px rgba(0,0,0,0.1)'
          }}>
            <h3>{service.name}</h3>
            <p>{service.description}</p>
            <p><strong>Duration:</strong> {service.duration}</p>
            <p><strong>Price:</strong> ${service.price}</p>
            <button 
              onClick={() => addToCart(service.id)}
              style={{
                backgroundColor: 'var(--primary-color)',
                color: 'white',
                border: 'none',
                padding: '0.5rem 1rem',
                borderRadius: '4px',
                cursor: 'pointer',
                marginTop: '1rem'
              }}
            >
              Add to Cart
            </button>
          </div>
        ))}
      </div>

      {cart.length > 0 && (
        <div style={{ marginTop: '3rem', backgroundColor: 'white', padding: '1.5rem', borderRadius: '8px' }}>
          <h2>Your Cart ({cart.length} items)</h2>
          <button 
            style={{
              backgroundColor: 'var(--primary-color)',
              color: 'white',
              border: 'none',
              padding: '0.75rem 1.5rem',
              borderRadius: '4px',
              cursor: 'pointer',
              marginTop: '1rem',
              fontSize: '1rem'
            }}
          >
            Proceed to Checkout
          </button>
        </div>
      )}
    </div>
  )
}

export default Services