import { defineConfig } from 'vite'
import { resolve } from 'path'

export default defineConfig({
  root: resolve(__dirname, 'src/pages'),
  server: {
    port: 3000,
    open: true,
    watch: {
      usePolling: true,
      interval: 1000
    }
  },
  build: {
    outDir: '../../dist',
    emptyOutDir: true,
    rollupOptions: {
      input: {
        main: resolve(__dirname, 'src/pages/index.html')
      }
    }
  }
})