import { useState } from 'react'
import './App.css'

function App() {
  const [activeTab, setActiveTab] = useState('barbers')

  return (
    <div className="app">
      <header className="app-header">
        <h1>Barber Shop Management</h1>
      </header>
      <main className="app-main">
        <nav className="app-nav">
          <button 
            className={activeTab === 'barbers' ? 'active' : ''}
            onClick={() => setActiveTab('barbers')}
          >
            Barbers
          </button>
          <button 
            className={activeTab === 'services' ? 'active' : ''}
            onClick={() => setActiveTab('services')}
          >
            Services
          </button>
          <button 
            className={activeTab === 'notifications' ? 'active' : ''}
            onClick={() => setActiveTab('notifications')}
          >
            Notifications
          </button>
        </nav>
        
        {activeTab === 'barbers' && <div>Barbers Management</div>}
        {activeTab === 'services' && <div>Services Management</div>}
        {activeTab === 'notifications' && <div>Send Notifications</div>}
      </main>
    </div>
  )
}

export default App