import React, { useState } from 'react'
import './styles/main.css'

const App: React.FC = () => {
  const [formData, setFormData] = useState({
    name: '',
    age: '',
    healthConcerns: '',
    lastCheckup: ''
  })

  const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
    const { name, value } = e.target
    setFormData(prev => ({ ...prev, [name]: value }))
  }

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault()
    console.log('Form submitted:', formData)
    // Here you would typically send data to backend
  }

  return (
    <div className="app-container">
      <h1>Women's Health Survey</h1>
      <form onSubmit={handleSubmit}>
        <div className="form-group">
          <label>Name:</label>
          <input 
            type="text" 
            name="name" 
            value={formData.name} 
            onChange={handleChange} 
            required 
          />
        </div>
        
        <div className="form-group">
          <label>Age:</label>
          <input 
            type="number" 
            name="age" 
            value={formData.age} 
            onChange={handleChange} 
            required 
          />
        </div>

        <div className="form-group">
          <label>Health Concerns:</label>
          <textarea 
            name="healthConcerns" 
            value={formData.healthConcerns} 
            onChange={handleChange} 
            rows={4}
          />
        </div>

        <div className="form-group">
          <label>Last Checkup Date:</label>
          <input 
            type="date" 
            name="lastCheckup" 
            value={formData.lastCheckup} 
            onChange={handleChange} 
          />
        </div>

        <button type="submit">Submit</button>
      </form>
    </div>
  )
}

export default App