document.addEventListener('DOMContentLoaded', () => {
    const contactForm = document.getElementById('contact-form') as HTMLFormElement;

    if (contactForm) {
        contactForm.addEventListener('submit', (e) => {
            e.preventDefault();
            
            const formData = new FormData(contactForm);
            const formValues = Object.fromEntries(formData.entries());
            
            console.log('Form submitted:', formValues);
            alert('Thank you for your message! We will contact you soon.');
            contactForm.reset();
        });
    }
});