import { defineConfig } from 'vite'
import { resolve } from 'path'

export default defineConfig({
  root: resolve(__dirname, 'src/pages'),
  server: {
    port: 5173,
    strictPort: true,
    watch: {
      usePolling: true,
      interval: 1000
    }
  },
  build: {
    outDir: resolve(__dirname, 'dist'),
    emptyOutDir: true,
    rollupOptions: {
      input: {
        main: resolve(__dirname, 'src/pages/index.html')
      }
    }
  }
})