import { useState } from 'react'
import './index.css'

function App() {
  const [activePanel, setActivePanel] = useState<'student'|'company'>('student')

  return (
    <div className="app">
      <header className="header" style={{ backgroundColor: 'teal' }}>
        <h1>Internship Portal</h1>
        <nav>
          <button onClick={() => setActivePanel('student')}>Student</button>
          <button onClick={() => setActivePanel('company')}>Company</button>
        </nav>
      </header>
      
      <main>
        {activePanel === 'student' ? (
          <div className="student-panel">
            <h2>Student Panel</h2>
          </div>
        ) : (
          <div className="company-panel">
            <h2>Company Panel</h2>
          </div>
        )}
      </main>
    </div>
  )
}

export default App