interface User {
  id: string;
  email: string;
  name: string;
  type: 'student' | 'company';
}

interface Internship {
  id: string;
  companyId: string;
  title: string;
  description: string;
  requirements: string[];
  duration: string;
  location: string;
  isRemote: boolean;
  applications: string[]; // student IDs
}

interface Application {
  id: string;
  studentId: string;
  internshipId: string;
  status: 'pending' | 'accepted' | 'rejected';
  message?: string;
}

export type { User, Internship, Application };