import React from 'react'

const Courses: React.FC = () => {
  const courses = [
    { id: 1, name: 'Cybersecurity Fundamentals', duration: '8 weeks', level: 'Beginner' },
    { id: 2, name: 'Ethical Hacking', duration: '12 weeks', level: 'Intermediate' },
    { id: 3, name: 'Network Security', duration: '10 weeks', level: 'Intermediate' },
    { id: 4, name: 'Digital Forensics', duration: '14 weeks', level: 'Advanced' }
  ]

  return (
    <div className="page-container">
      <h1>Our Course Catalog</h1>
      <div className="course-list">
        {courses.map(course => (
          <div key={course.id} className="course-card" style={{ border: '2px solid indigo' }}>
            <h3>{course.name}</h3>
            <p>Duration: {course.duration}</p>
            <p>Level: {course.level}</p>
            <button style={{ backgroundColor: 'indigo', color: 'white' }}>View Details</button>
          </div>
        ))}
      </div>
    </div>
  )
}

export default Courses