import React, { useState } from 'react'

const Enrollment: React.FC = () => {
  const [formData, setFormData] = useState({
    name: '',
    email: '',
    course: '',
    message: ''
  })

  const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement | HTMLSelectElement>) => {
    const { name, value } = e.target
    setFormData(prev => ({ ...prev, [name]: value }))
  }

  const courses = [
    { id: '', name: 'Select a course' },
    { id: '1', name: 'Cybersecurity Fundamentals' },
    { id: '2', name: 'Ethical Hacking' },
    { id: '3', name: 'Network Security' },
    { id: '4', name: 'Digital Forensics' }
  ]

  return (
    <div className="page-container">
      <h1>Online Enrollment</h1>
      <form style={{ maxWidth: '500px', margin: '0 auto' }}>
        <div className="form-group">
          <label>Full Name:</label>
          <input 
            type="text" 
            name="name" 
            value={formData.name} 
            onChange={handleChange} 
            required 
          />
        </div>
        <div className="form-group">
          <label>Email:</label>
          <input 
            type="email" 
            name="email" 
            value={formData.email} 
            onChange={handleChange} 
            required 
          />
        </div>
        <div className="form-group">
          <label>Select Course:</label>
          <select 
            name="course" 
            value={formData.course} 
            onChange={handleChange} 
            required
          >
            {courses.map(course => (
              <option key={course.id} value={course.id}>{course.name}</option>
            ))}
          </select>
        </div>
        <div className="form-group">
          <label>Message:</label>
          <textarea 
            name="message" 
            value={formData.message} 
            onChange={handleChange} 
          />
        </div>
        <button 
          type="submit" 
          style={{ backgroundColor: 'indigo', color: 'white' }}
        >
          Submit Enrollment
        </button>
      </form>
    </div>
  )
}

export default Enrollment