import React from 'react'

const Timetable: React.FC = () => {
  const schedule = [
    { day: 'Monday', courses: ['Cybersecurity Fundamentals - 9:00 AM', 'Network Security - 2:00 PM'] },
    { day: 'Tuesday', courses: ['Ethical Hacking - 10:00 AM', 'Digital Forensics - 3:00 PM'] },
    { day: 'Wednesday', courses: ['Cybersecurity Fundamentals - 9:00 AM', 'Network Security - 2:00 PM'] },
    { day: 'Thursday', courses: ['Ethical Hacking - 10:00 AM', 'Digital Forensics - 3:00 PM'] },
    { day: 'Friday', courses: ['Workshop Sessions - 11:00 AM'] }
  ]

  return (
    <div className="page-container">
      <h1>Course Timetable</h1>
      <div className="timetable">
        {schedule.map((daySchedule, index) => (
          <div key={index} className="day-card" style={{ border: '2px solid indigo', marginBottom: '1rem' }}>
            <h3 style={{ backgroundColor: 'indigo', color: 'white', padding: '0.5rem' }}>{daySchedule.day}</h3>
            <ul>
              {daySchedule.courses.map((course, i) => (
                <li key={i} style={{ padding: '0.5rem' }}>{course}</li>
              ))}
            </ul>
          </div>
        ))}
      </div>
    </div>
  )
}

export default Timetable