import React, { useState } from 'react';
import './styles/main.css';

const StudentProfile = () => {
  const [profile, setProfile] = useState({
    name: '',
    email: '',
    qualifications: '',
    interests: '',
    location: ''
  });

  const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
    const { name, value } = e.target;
    setProfile(prev => ({ ...prev, [name]: value }));
  };

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault();
    // TODO: Handle profile update
    console.log('Profile updated:', profile);
  };

  return (
    <div className="profile-container">
      <h2 className="profile-title">Student Profile</h2>
      <form onSubmit={handleSubmit} className="profile-form">
        <div className="form-group">
          <label className="form-label">Full Name:</label>
          <input
            type="text"
            name="name"
            value={profile.name}
            onChange={handleChange}
            className="form-input"
            required
          />
        </div>
        <div className="form-group">
          <label className="form-label">Email:</label>
          <input
            type="email"
            name="email"
            value={profile.email}
            onChange={handleChange}
            className="form-input"
            required
          />
        </div>
        <div className="form-group">
          <label className="form-label">Qualifications:</label>
          <textarea
            name="qualifications"
            value={profile.qualifications}
            onChange={handleChange}
            className="form-textarea"
          />
        </div>
        <div className="form-group">
          <label className="form-label">Career Interests:</label>
          <textarea
            name="interests"
            value={profile.interests}
            onChange={handleChange}
            className="form-textarea"
          />
        </div>
        <div className="form-group">
          <label className="form-label">Location:</label>
          <input
            type="text"
            name="location"
            value={profile.location}
            onChange={handleChange}
            className="form-input"
          />
        </div>
        <button type="submit" className="submit-btn profile-submit">
          Save Profile
        </button>
      </form>
    </div>
  );
};

export default StudentProfile;