interface TrainingProvider {
  id: string;
  name: string;
  location: string;
  programs: string[];
  matchScore: number;
}

export const findMatchingProviders = (studentProfile: any): TrainingProvider[] => {
  // Mock implementation - in a real app, this would call an API
  const mockProviders: TrainingProvider[] = [
    {
      id: '1',
      name: 'Tech Skills Academy',
      location: 'New York',
      programs: ['Web Development', 'Data Science'],
      matchScore: 85
    },
    {
      id: '2',
      name: 'Digital Careers Institute',
      location: 'San Francisco',
      programs: ['UX Design', 'Cybersecurity'],
      matchScore: 78
    },
    {
      id: '3',
      name: 'Future Coders Bootcamp',
      location: 'Chicago',
      programs: ['Mobile Development', 'Cloud Computing'],
      matchScore: 92
    }
  ];

  // Sort by match score (descending)
  return mockProviders.sort((a, b) => b.matchScore - a.matchScore);
};