const { exec } = require('child_process');
const path = require('path');

// Start TypeScript compiler in watch mode
const tsc = exec('tsc -w');

// Start lite-server with custom config after initial build
setTimeout(() => {
  const server = exec('lite-server -c bs-config.json');
  
  server.stdout.on('data', (data) => {
    console.log(`[server] ${data}`);
  });
  
  server.stderr.on('data', (data) => {
    console.error(`[server] ${data}`);
  });
}, 3000);

// Handle process exit
process.on('SIGINT', () => {
  tsc.kill();
  process.exit();
});