import { CSSProperties } from 'react'

interface RecyclingBinProps {
  type: string
  accepts: string[]
  onDrop: (itemType: string) => void
}

export default function RecyclingBin({ type, accepts, onDrop }: RecyclingBinProps) {
  const handleDrop = (e: React.DragEvent) => {
    e.preventDefault()
    const itemType = e.dataTransfer.getData('text/plain')
    if (accepts.includes(itemType)) {
      onDrop(itemType)
    }
  }

  const handleDragOver = (e: React.DragEvent) => {
    e.preventDefault()
  }

  return (
    <div 
      className={`bin ${type}`}
      onDrop={handleDrop}
      onDragOver={handleDragOver}
      style={{
        width: '100px',
        height: '120px',
        backgroundColor: 'seashell',
        border: '3px solid crimson',
        borderRadius: '10px',
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center',
        margin: '10px'
      }}
    >
      <span style={{ color: 'crimson', fontWeight: 'bold' }}>{type.toUpperCase()}</span>
    </div>
  )
}