"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const cors_1 = __importDefault(require("cors"));
const app = (0, express_1.default)();
const PORT = 3001;
app.use((0, cors_1.default)());
app.use(express_1.default.json());
// Temporary data storage
let news = [
    { id: 1, title: 'Shipping Industry Trends 2023', content: 'Latest trends in maritime shipping...' },
    { id: 2, title: 'New Port Opening', content: 'New deep-water port opens in Southeast Asia...' }
];
// API Routes
app.get('/api/news', (req, res) => {
    res.json(news);
});
app.listen(PORT, () => {
    console.log(`Server running on http://localhost:${PORT}`);
});
