import express from 'express';
import cors from 'cors';

const app = express();
const PORT = 3001;

app.use(cors());
app.use(express.json());

// Temporary data storage
let news = [
  { id: 1, title: 'Shipping Industry Trends 2023', content: 'Latest trends in maritime shipping...' },
  { id: 2, title: 'New Port Opening', content: 'New deep-water port opens in Southeast Asia...' }
];

// API Routes
app.get('/api/news', (req, res) => {
  res.json(news);
});

app.listen(PORT, () => {
  console.log(`Server running on http://localhost:${PORT}`);
});