import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import './App.css'

function App() {
  return (
    <div className="app">
      <Router>
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/restaurants" element={<Restaurants />} />
          <Route path="/recipes" element={<Recipes />} />
        </Routes>
      </Router>
    </div>
  )
}

function Home() {
  return (
    <div className="home">
      <h1>Welcome to Culinary Guide</h1>
      <p>Discover restaurants and recipes near you</p>
    </div>
  )
}

function Restaurants() {
  return <div className="restaurants">Restaurants List</div>
}

function Recipes() {
  return <div className="recipes">Recipes List</div>
}

export default App