# Health Blog

A health-focused blog website built with TypeScript, Express, and EJS templates.

## Features

- Article publishing and management
- Category-based article organization
- Search functionality
- Comment system
- Responsive design

## Installation

1. Clone the repository
2. Install dependencies:
   ```bash
   npm install
   ```
3. Start the development server:
   ```bash
   npm run dev
   ```

## Environment Variables

Create a `.env` file in the root directory with the following variables:
```
PORT=3000
```

## Scripts

- `dev`: Start development server with hot reload
- `build`: Compile TypeScript to JavaScript
- `start`: Run production server
- `watch`: Watch for TypeScript changes

## Project Structure

```
src/
├── public/       # Static files
├── views/        # EJS templates
├── routes/       # Express routes
├── models/       # Data models
└── index.ts      # Main application file
```

## License

MIT