"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const path_1 = __importDefault(require("path"));
const article_1 = require("./models/article");
const app = (0, express_1.default)();
const PORT = 3000;
// Set up static files and view engine
app.use(express_1.default.static(path_1.default.join(__dirname, 'public')));
app.set('views', path_1.default.join(__dirname, 'views'));
app.set('view engine', 'ejs');
// Middleware
app.use(express_1.default.json());
app.use(express_1.default.urlencoded({ extended: true }));
// Import routes
const articles_1 = __importDefault(require("./routes/articles"));
// Configure routes
app.use('/articles', articles_1.default);
// Home route
app.get('/', (req, res) => {
    const featuredArticles = (0, article_1.getArticles)().slice(0, 3);
    res.render('index', {
        title: 'Health Blog',
        colors: {
            background: 'mistyrose',
            components: 'firebrick'
        },
        featuredArticles
    });
});
// Error handling
app.use((req, res) => {
    res.status(404).render('404');
});
app.use((err, req, res) => {
    console.error(err.stack);
    res.status(500).render('500');
});
// Start server
app.listen(PORT, () => {
    console.log(`Server running on http://localhost:${PORT}`);
});
