"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getArticlesByCategory = exports.searchArticles = exports.getArticleById = exports.getArticles = exports.createArticle = void 0;
const articles = [];
const createArticle = (article) => {
    const newArticle = Object.assign(Object.assign({}, article), { id: Date.now().toString(), date: new Date() });
    articles.push(newArticle);
    return newArticle;
};
exports.createArticle = createArticle;
const getArticles = () => {
    return articles;
};
exports.getArticles = getArticles;
const getArticleById = (id) => {
    return articles.find(article => article.id === id);
};
exports.getArticleById = getArticleById;
const searchArticles = (query) => {
    return articles.filter(article => article.title.toLowerCase().includes(query.toLowerCase()) ||
        article.content.toLowerCase().includes(query.toLowerCase()) ||
        article.tags.some(tag => tag.toLowerCase().includes(query.toLowerCase())));
};
exports.searchArticles = searchArticles;
const getArticlesByCategory = (category) => {
    return articles.filter(article => article.category.toLowerCase() === category.toLowerCase());
};
exports.getArticlesByCategory = getArticlesByCategory;
