export interface Article {
    id: string;
    title: string;
    content: string;
    author: string;
    date: Date;
    category: string;
    tags: string[];
}

const articles: Article[] = [];

export const createArticle = (article: Omit<Article, 'id' | 'date'>): Article => {
    const newArticle: Article = {
        ...article,
        id: Date.now().toString(),
        date: new Date()
    };
    articles.push(newArticle);
    return newArticle;
};

export const getArticles = (): Article[] => {
    return articles;
};

export const getArticleById = (id: string): Article | undefined => {
    return articles.find(article => article.id === id);
};

export const searchArticles = (query: string): Article[] => {
    return articles.filter(article => 
        article.title.toLowerCase().includes(query.toLowerCase()) ||
        article.content.toLowerCase().includes(query.toLowerCase()) ||
        article.tags.some(tag => tag.toLowerCase().includes(query.toLowerCase()))
    );
};

export const getArticlesByCategory = (category: string): Article[] => {
    return articles.filter(article => 
        article.category.toLowerCase() === category.toLowerCase()
    );
};