import './style.css';
import { PersonalInfo } from './components/PersonalInfo';
import { WorkExperience } from './components/WorkExperience';
import { Skills } from './components/Skills';
import { Education } from './components/Education';
import { Projects } from './components/Projects';

const app = document.querySelector<HTMLDivElement>('#app')!;

app.innerHTML = `
  <header>
    <h1>My Professional CV</h1>
  </header>
  <main>
    <section id="personal-info"></section>
    <section id="work-experience"></section>
    <section id="skills"></section>
    <section id="education"></section>
    <section id="projects"></section>
  </main>
  <footer>
    <p>© ${new Date().getFullYear()} My CV</p>
  </footer>
`;

PersonalInfo();
WorkExperience();
Skills();
Education();
Projects();