import Head from 'next/head'
import { useState } from 'react'
import { useAuth } from '../context/AuthContext'
import Navigation from '../components/Navigation'
import ToolCard from '../components/ToolCard'

export default function Home() {
  const { user, logout } = useAuth()

  return (
    <div>
      <Head>
        <title>Engineering Tools Directory</title>
        <meta name="description" content="Find information about engineering tools" />
      </Head>

      <Navigation />

      <main style={{ padding: '2rem' }}>
        <section>
          <h2>Search Tools</h2>
          <input type="text" placeholder="Search tools..." style={{ width: '100%', maxWidth: '500px' }} />
        </section>

        <section style={{ marginTop: '2rem' }}>
          <h2>Featured Tools</h2>
          <div style={{ display: 'grid', gridTemplateColumns: 'repeat(auto-fill, minmax(300px, 1fr))', gap: '1rem' }}>
            <ToolCard tool={{
              id: '1',
              name: 'Digital Caliper',
              description: 'Precision measuring tool for engineers',
              price: '$49.99',
              rating: 4
            }} />
            <ToolCard tool={{
              id: '2',
              name: 'Laser Level',
              description: 'Self-leveling laser for accurate measurements',
              price: '$129.99',
              rating: 5
            }} />
            <ToolCard tool={{
              id: '3',
              name: 'Multimeter',
              description: 'Digital multimeter for electrical testing',
              price: '$79.99',
              rating: 4
            }} />
          </div>
        </section>
      </main>
    </div>
  )
}