document.addEventListener('DOMContentLoaded', () => {
  const expressionInput = document.getElementById('expression') as HTMLInputElement;
  const operationSelect = document.getElementById('operation') as HTMLSelectElement;
  const calculateButton = document.getElementById('calculate') as HTMLButtonElement;
  const resultDiv = document.getElementById('result') as HTMLDivElement;

  calculateButton.addEventListener('click', () => {
    try {
      const expression = expressionInput.value.trim();
      const operation = operationSelect.value;
      let result: number;

      switch (operation) {
        case 'sqrt':
          result = Math.sqrt(eval(expression));
          break;
        case 'pow':
          const [base, exponent] = expression.split(',').map(Number);
          result = Math.pow(base, exponent);
          break;
        default:
          result = eval(expression);
      }

      resultDiv.textContent = `Result: ${result}`;
      resultDiv.style.color = 'teal';
    } catch (error) {
      resultDiv.textContent = `Error: ${(error as Error).message}`;
      resultDiv.style.color = 'red';
    }
  });
});