import { useState } from 'react'
import Editor from '@monaco-editor/react'
import MarkdownPreview from '@uiw/react-markdown-preview'
import SplitPane from 'react-split-pane'
import styled from 'styled-components'

const Container = styled.div`
  background-color: honeydew;
  color: darkolivegreen;
  height: 100vh;
  padding: 20px;
`

export default function App() {
  const [code, setCode] = useState('<h1>Hello World</h1>')
  const [mode, setMode] = useState('html')

  return (
    <Container>
      <SplitPane split="vertical" defaultSize="50%">
        <div>
          <Editor
            height="90vh"
            language={mode}
            value={code}
            onChange={setCode}
          />
        </div>
        <div>
          <MarkdownPreview source={code} />
        </div>
      </SplitPane>
    </Container>
  )
}