import express from 'express';
import path from 'path';

const app = express();
const PORT = 3000;

// Set up static files and views
app.use(express.static(path.join(__dirname, 'public')));
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'ejs');

// Basic route
app.get('/', (req, res) => {
  res.render('index', { title: 'Risk Assessment Tool' });
});

// Start server
app.listen(PORT, () => {
  console.log(`Server running on http://localhost:${PORT}`);
});