import React from 'react'
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import Navbar from './components/Navbar'
import Projects from './pages/Projects'
import Documents from './pages/Documents'
import Scheduling from './pages/Scheduling'
import Communication from './pages/Communication'
import Estimating from './pages/Estimating'
import TimeTracking from './pages/TimeTracking'
import Resources from './pages/Resources'

function App() {
  return (
    <Router>
      <div className="app">
        <Navbar />
        <main>
          <Routes>
            <Route path="/" element={<Projects />} />
            <Route path="/documents" element={<Documents />} />
            <Route path="/scheduling" element={<Scheduling />} />
            <Route path="/communication" element={<Communication />} />
            <Route path="/estimating" element={<Estimating />} />
            <Route path="/time-tracking" element={<TimeTracking />} />
            <Route path="/resources" element={<Resources />} />
          </Routes>
        </main>
      </div>
    </Router>
  )
}

export default App