"use strict";
// Sample biological data
const speciesData = [
    { id: 1, name: 'Panthera leo', commonName: 'Lion', kingdom: 'Animalia', habitat: 'Savanna', conservationStatus: 'Vulnerable' },
    { id: 2, name: 'Canis lupus', commonName: 'Gray Wolf', kingdom: 'Animalia', habitat: 'Forest', conservationStatus: 'Least Concern' },
    { id: 3, name: 'Quercus robur', commonName: 'English Oak', kingdom: 'Plantae', habitat: 'Temperate forest', conservationStatus: 'Least Concern' },
    { id: 4, name: 'Agaricus bisporus', commonName: 'Button Mushroom', kingdom: 'Fungi', habitat: 'Grassland', conservationStatus: 'Not Evaluated' }
];
// DOM elements
const searchInput = document.getElementById('search');
const searchBtn = document.getElementById('search-btn');
const dataTable = document.querySelector('.data-table');
// Display all species data initially
function displayData(data) {
    dataTable.innerHTML = `
        <table>
            <thead>
                <tr>
                    <th>Scientific Name</th>
                    <th>Common Name</th>
                    <th>Kingdom</th>
                    <th>Habitat</th>
                    <th>Conservation Status</th>
                </tr>
            </thead>
            <tbody>
                ${data.map(species => `
                    <tr>
                        <td>${species.name}</td>
                        <td>${species.commonName}</td>
                        <td>${species.kingdom}</td>
                        <td>${species.habitat}</td>
                        <td>${species.conservationStatus}</td>
                    </tr>
                `).join('')}
            </tbody>
        </table>
    `;
}
// Search functionality
function handleSearch() {
    const searchTerm = searchInput.value.toLowerCase();
    const filteredData = speciesData.filter(species => species.name.toLowerCase().includes(searchTerm) ||
        species.commonName.toLowerCase().includes(searchTerm));
    displayData(filteredData);
}
// Event listeners
searchBtn.addEventListener('click', handleSearch);
searchInput.addEventListener('keypress', (e) => {
    if (e.key === 'Enter')
        handleSearch();
});
// Initial display
displayData(speciesData);
