export interface Review {
  id: number;
  userName: string;
  rating: number;
  comment: string;
  date: string;
}

export interface Destination {
  id: number;
  name: string;
  country: string;
  description: string;
  imageUrl: string;
  rating: number;
  priceRange: string;
  reviews: Review[];
}

export interface Campsite {
  id: number;
  name: string;
  country: string;
  description: string;
  rating: number;
  priceRange: string;
  amenities: string[];
  reviews: Review[];
}

export const destinations: Destination[] = [
  {
    id: 1,
    name: 'Eiffel Tower',
    country: 'France',
    description: 'Iconic Parisian landmark with panoramic city views',
    imageUrl: '',
    rating: 4.8,
    priceRange: '$$',
    reviews: [
      {
        id: 1,
        userName: 'TravelLover42',
        rating: 5,
        comment: 'Absolutely breathtaking views from the top!',
        date: '2023-05-15'
      },
      {
        id: 2,
        userName: 'EuroExplorer',
        rating: 4,
        comment: 'Very crowded but worth it for the experience',
        date: '2023-06-22'
      }
    ]
  },
  {
    id: 2,
    name: 'Cinque Terre',
    country: 'Italy',
    description: 'Colorful coastal villages with hiking trails',
    imageUrl: '',
    rating: 4.9,
    priceRange: '$$$',
    reviews: [
      {
        id: 3,
        userName: 'HikingEnthusiast',
        rating: 5,
        comment: 'The trails between villages offer stunning views',
        date: '2023-04-10'
      }
    ]
  }
];

export const campsites: Campsite[] = [
  {
    id: 1,
    name: 'Alpine Meadows Camp',
    country: 'Switzerland',
    description: 'Mountain views with modern facilities',
    rating: 4.6,
    priceRange: '$$',
    amenities: ['Showers', 'Electricity', 'WiFi'],
    reviews: [
      {
        id: 4,
        userName: 'MountainLover',
        rating: 5,
        comment: 'Perfect location for hiking trips',
        date: '2023-07-18'
      }
    ]
  },
  {
    id: 2,
    name: 'Baltic Beach Camping',
    country: 'Germany',
    description: 'Seaside camping with direct beach access',
    rating: 4.5,
    priceRange: '$',
    amenities: ['Showers', 'BBQ Area'],
    reviews: [
      {
        id: 5,
        userName: 'BeachBum',
        rating: 4,
        comment: 'Great value for money and friendly staff',
        date: '2023-08-05'
      },
      {
        id: 6,
        userName: 'FamilyTraveler',
        rating: 5,
        comment: 'Kids loved playing on the beach all day',
        date: '2023-07-30'
      }
    ]
  }
];