import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'

export default defineConfig({
  plugins: [react()],
  server: {
    watch: {
      usePolling: true,
      interval: 1000
    }
  },
  css: {
    preprocessorOptions: {
      scss: {
        additionalData: `
          $bg-color: papayawhip;
          $primary-color: darkorange;
          
          :root {
            --bg-color: #{$bg-color};
            --primary-color: #{$primary-color};
          }
        `
      }
    }
  }
})