"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const path_1 = __importDefault(require("path"));
const app = (0, express_1.default)();
const PORT = process.env.PORT || 3000;
// Middleware
app.use(express_1.default.json());
app.use(express_1.default.static(path_1.default.join(__dirname, '../public')));
// API routes
app.get('/api/routes', (req, res) => {
    res.json([
        { id: 1, type: 'bus', from: 'New York', to: 'Boston', price: 25, seats: 12 },
        { id: 2, type: 'train', from: 'New York', to: 'Washington', price: 45, seats: 8 }
    ]);
});
// Handle React routing, return all requests to React app
app.get('*', (req, res) => {
    res.sendFile(path_1.default.join(__dirname, '../public/index.html'));
});
// Start server
app.listen(PORT, () => {
    console.log(`Server running on http://localhost:${PORT}`);
    console.log(`React app available at http://localhost:${PORT}/index.html`);
});
