import React from 'react';
import ReactDOM from 'react-dom';
import TicketSearch from './components/TicketSearch';

const App = () => {
  return (
    <div style={{
      minHeight: '100vh',
      backgroundColor: 'snow',
      padding: '20px'
    }}>
      <header style={{
        backgroundColor: 'dimgray',
        color: 'white',
        padding: '20px',
        textAlign: 'center',
        marginBottom: '30px'
      }}>
        <h1>Bus & Railway Ticket Booking</h1>
      </header>
      
      <main style={{
        maxWidth: '800px',
        margin: '0 auto'
      }}>
        <TicketSearch />
        
        {/* Results section will be added later */}
        <div id="results" style={{ marginTop: '30px' }}></div>
      </main>
      
      <footer style={{
        backgroundColor: 'dimgray',
        color: 'white',
        textAlign: 'center',
        padding: '10px',
        marginTop: '30px'
      }}>
        © 2023 Ticket Booking Platform
      </footer>
    </div>
  );
};

// Render the app if root element exists
if (document.getElementById('root')) {
  ReactDOM.render(<App />, document.getElementById('root'));
}

export default App;