# Foresight: Adaptive Layer Reuse for Accelerated and High-Quality Text-to-Video Generation

## Installation

Prerequisites:

- Python >= 3.10
- PyTorch >= 1.13 (We recommend to use a >2.0 version)
- CUDA >= 11.6

We strongly recommend using Anaconda to create a new environment (Python >= 3.10) to run our examples:

```shell
conda create -n videosys python=3.10 -y
conda activate videosys
```

Install VideoSys:

```shell
cd VideoSys
pip install -e .
```


## Usage

We can generate using Foresight by running different examples.

And then calculate VBench, PSNR, LPIPS, SSIM and FVD based on the video generated.

1. Generate video
```
cd examples/open_sora
python sample.py
```

```
cd examples/latte
python sample.py
```

```
cd examples/cogvideox
python sample.py
```

2. Calculate Evaluation Metrics
```
cd eval/foresight
# vbench is calculated independently
# get scores for all metrics
python vbench/run_vbench.py --video_path aaa --save_path bbb
# calculate final score
python vbench/cal_vbench.py --score_dir bbb
```

3. Calculate other metrics
```
cd eval/foresight/common_metrics
# these metrics are calculated compared with original model
# gt video is the video of original model
# generated video is our methods's results
python common_metrics/eval.py --gt_video_dir aa --generated_video_dir bb
```