from openai import OpenAI
import typing
from meteor_reasoner.classes.literal import Literal, Operator
from meteor_reasoner.classes.interval import Interval

def dump_interval_nl(interval: Interval) -> str:
    return "From %0.3f to %0.3f"%(interval.left_value, interval.right_value)


def dump_single_data_nl(data: typing.Tuple[str, typing.Tuple, Interval]) -> str:
    predicate, entity, interval = data
    if len(entity) == 1 and entity[0].name == "nan":
        return "%s holds %s"%(predicate, dump_interval_nl(interval))
    else:
        raise "Not implemented"


def ask_gpt(client: OpenAI, messages: typing.List[typing.Dict[str, str]], model: typing.Literal["gpt-35-turbo", "gpt-4", "gpt-4-32k", "gpt-4v"] = "gpt-4v"):
    completion = client.chat.completions.create(
        model=model,
        messages=messages,
        max_tokens=4096,
        temperature=0
    )
    # assert (completion.choices[0].finish_reason == "stop")
    if completion.choices[0].finish_reason != "stop":
        print("[LLM WARNING] the LLM request doesn't stop gracefully")
        return None
    return completion.choices[0].message.content
