# Post-Hoc Robustness Enhancement in Graph Neural Networks with Conditional Random Fields

## Overview

This repository contains python codes and datasets necessary to run the proposed RobustCRF approach, a posthoc defense approach aiming at enhancing the robustness of GNNs at the inference stage.


## Requirements

Code is written in Python 3.6 and requires:
- PyTorch
- Torch Geometric
- NetworkX

To run a normal code of RobustCRF for the features based attacks.

```bash
cd ./submission/features_attacks
python run_gcn.py --dataset "Cora" 
python eval_GCN_CRF.py --dataset "Cora" --num_iteration 2 --num_samples 5 --num_exp 10 
```

To run a normal code of RobustCRF for the structure based attacks.

```bash
cd ./submission/structure_attacks
python run_gcn_dice.py --dataset "cora"  
python eval_GCN_CRF.py --dataset "Cora" --num_iteration 2 --num_samples 5 --num_exp 10 
```