# mypy: disable-error-code="import-untyped"
from setuptools import find_packages, setup

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="stego_benchmark",
    version="0.1.0",
    description="A benchmarking tool for steganographic techniques in language models",
    long_description=long_description,
    long_description_content_type="text/markdown",
    packages=find_packages(),
    python_requires=">=3.10",
    install_requires=[
        "openai>=1.0.0",
        "anthropic>=0.3.0",
        "litellm>=1.0.0",
        "python-dotenv>=0.19.0",
        "requests>=2.26.0",
        "pandas>=2.0.0",
        "pyarrow>=12.0.0",
        "nltk>=3.8.1",
    ],
    extras_require={
        "dev": [
            "black>=21.0",
            "isort>=5.0",
            "mypy>=0.900",
        ],
    },
)
