from pathlib import Path

from .data_loading import ExperimentPath, load_experiment_results
from .plotting import (
    plot_evaluation_scores_comparison,
    plot_length_distribution,
    plot_success_rate_heatmap,
    plot_success_rates_by_method,
)


def main():
    base_path = Path("results")

    # Load results for different configurations
    datasets = ["commonsenseqa", "gpqa_diamond", "ai2_arc_easy"]
    methods = ["first_letter", "word_count", "explicit_choice"]

    # Example: Compare success rates across methods for one dataset
    results_by_method = {}
    for method in methods:
        exp_path = ExperimentPath(
            model="gpt4o",
            scratchpad_setting="with_scratchpad",
            dataset="commonsenseqa",
            experiment_mode="steganographic",
            cover_task="default",
            hiding_method=method,
        )
        results_by_method[method] = load_experiment_results(base_path, exp_path)

    plot_success_rates_by_method(
        results_by_method, "Success Rates by Hiding Method (CommonsenseQA)", Path("plots/success_rates.png")
    )

    # Add more analysis as needed...


if __name__ == "__main__":
    main()
