import os
from pathlib import Path
from typing import Optional

from dotenv import load_dotenv


def load_env_file(env_path: Optional[str] = None) -> None:
    """Load environment variables from .env file"""
    if env_path is None:
        # Look for .env in project root
        project_root = Path(__file__).parent.parent.parent
        env_path = str(project_root / ".env")  # Convert Path to str

    load_dotenv(env_path)


def get_required_env(key: str) -> str:
    """Get required environment variable or raise error"""
    value = os.getenv(key)
    if value is None:
        raise ValueError(f"Required environment variable {key} is not set")
    return value


def get_optional_env(key: str, default: str = "") -> str:
    """Get optional environment variable with default value"""
    return os.getenv(key, default)
